/**
* Script: items.js
* Written by: Radnen
* Updated: 7/18/2010
**/

/* Useage Contsants: */
const USE_ENEMY = 0;
const USE_SELF  = 1;
const USE_OTHER = 2;

function Item(name, price, use)
{
	this.name = name;
	this.price = price;
	this.use = use;
	this.doAction = null;
	this.desc = "";
}

function Bandaid()
{
	this.inherit = Item;
	this.inherit("Bandaid", 15, USE_SELF);
	
	this.doAction = function(target) { target.hp.value += 10; }
	this.desc = "Use on self: Restores 10 hp.";
}

function FireScroll()
{
	this.inherit = Item;
	this.inherit("Fire Scroll", 80, USE_ENEMY);
	
	this.doAction = function(target) { target.hp.value -= 20; }
	this.desc = "Use on Enemy: Burns enemy for 20 damage.";
}

function Revive()
{
	this.inherit = Item;
	this.inherit("Revive", 100, USE_OTHER);
	
	this.doAction = function(target) { target.hp.value += target.hp.max*0.25; target.dead = false; }
	this.desc = "Use on Other: Revives and restores 25% of full health.";
}